	clear all
	close all
	clc
	L = 31;
	N = L-1;				% Filter order
	w = RECTANGULAR_WINDOW(N);
	w = VON_HANN_WINDOW(N)
	%	w = HAMMING_WINDOW(N)
	%	w = BARTLETT_WINDOW(N)
	%	w = BLACKMAN_WINDOW(N)
		% w = KAISER_WINDOW(N, 40)
 	%
	figure(1)				% Plot the window
	subplot('position', [0.1 0.4 0.86 0.5]);
	ylabel = 'w';
	PLOT_SEQUENCE(w, ylabel)
	wT = linspace(0, pi, 2000);
	H = zeros(1, length(wT));
	for n = 1:L
		H = H + w(n).*exp(i*n.*wT);
	end
	figure(2)				% Plot the magnitude for the window	
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_MAG_ZW(wT, H)

%	figure(2)				% Plot poles and zeros for the window
%	Z = roots(w);
%	P = zeros(1, N);
%	subplot('position', [0.1 0.4 0.86 0.5]);
%	PLOT_PZ_Z(Z, P)

	% Design of a lowpass filter using the window method
	WcT = pi/4;
	h = zeros(1, L); 
	h = IDEAL_IMPULSE_LP_Z(WcT, N);
	hLP = w.*h;
	H = zeros(1, length(wT));
 	for n = 1:L				% Compute the frequency response
 		H = H + hLP(n).*exp(i*n.*wT);
	end
	figure(3)				% Plot magnitude response for the lowpass filter
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_MAG_Z_dB(wT, H, pi, 70, 'H')
	
	figure(4)				% Plot the poles and zeros for the lowpass filter
	Z = roots(hLP);
	P = zeros(1,N);
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_PZ_Z(Z, P)
	
	figure(5)				 % Plot the impulse response for the lowpass filter
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_SEQUENCE(hLP, 'hLP')	
